import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.PreparedStatement;
import java.sql.ResultSet;

import org.apache.commons.net.ftp.FTP;
import org.apache.commons.net.ftp.FTPClient;
import org.apache.commons.net.ftp.FTPReply;

import com.jcraft.jsch.Channel;
import com.jcraft.jsch.ChannelSftp;
import com.jcraft.jsch.JSch;
import com.jcraft.jsch.Session;

public class DDUKStockUpdateStandalon {
	
	private String hostName = "";  
	private String username = "";     
	private String password = "";  	
	private String remoteFilePath = "";
	private String csvFileNameUpd = "";
	private String uploadProtocol = "";

	public static void main(String args[])
	{
		DDUKStockUpdateStandalon ddStock = new DDUKStockUpdateStandalon();
		
		try{
			ddStock.schedule();
		}
		catch(Exception e){
			System.out.println("DDUKStockUpdateStandalon.main(): Exception occured in main ()");
			e.printStackTrace();
		}
	}
	public String schedule()throws Exception
	{
		System.out.println("calling Standalone Scheduler Stock..................");
		Connection conn = null;
		
		String fileName = "Stock.csv";
		String remoteFileName = "Stock.csv";
		try
		{
			setDDSalesConfig();
			
			Class.forName("oracle.jdbc.driver.OracleDriver");
			System.out.println("Oracle class loaded sucessfully!");
			conn = DriverManager.getConnection("jdbc:oracle:thin:@192.223.14.91:1521:rdwdb", "ddwmsuk", "");
			System.out.println("Connection created successfully!");
			
			System.out.println("csvFileNameUpd12---->>["+csvFileNameUpd+"]");

			File file = new File(csvFileNameUpd);
			System.out.println("file.separatorChar---->>["+File.separatorChar+"]");
			file.mkdirs();
			char ch = csvFileNameUpd.charAt(csvFileNameUpd.length() -1 );
			System.out.println("Ch @@@@---->>["+ch+"]");			
			if(ch != File.separatorChar)
			{
				fileName = File.separator+fileName;
			}			

			generateCsvFile (csvFileNameUpd +fileName,conn);	
			System.out.println("CSV file successfully created....... ");
			final  String localFile = csvFileNameUpd+fileName;
			char ch1 = remoteFilePath.charAt(remoteFilePath.length() -1 );
			System.out.println("Ch @@@@---->>["+ch1+"]");			
			if(ch1 != File.separatorChar)
			{
				remoteFileName = File.separator+remoteFileName;
			}
			final  String remoteFile = remoteFilePath+remoteFileName;

			Thread t = new Thread()
			{
				public void run()
				{
					System.out.println("Thread started........");
					if("SFTP".equalsIgnoreCase(uploadProtocol))
					{
						putFileSFTP(username, hostName, password, remoteFilePath,localFile,22);
					}
					else
					{
						putFileFTP(username, hostName, password, remoteFile,localFile,21);
					}
					System.out.println("Thread commited........");
				}

			};

			t.start();

			System.out.println("End of program........");

		}
		catch(Exception e)
		{
			e.printStackTrace();
		}
		finally
		{

			if(conn != null)
			{
				conn.close();
				conn = null;
			}
		}
		return "";
	}
	private void setDDSalesConfig()
	{
		System.out.println("  in setDDSalesConfig -------------------------");
		
		try 
		{            	            	
			this.csvFileNameUpd = "C:/StockUpdate";
			this.hostName = "internal-internalrevdance-1200354049.eu-west-1.elb.amazonaws.com";
			this.username = "erpftp";
			this.password = "3nySu7qg9wFceWVC";
			this.remoteFilePath = "/nfs/csv/stock";
			this.uploadProtocol = "SFTP";
		}
		catch(Exception e)
		{
			e.printStackTrace();
		}      
	}
	private  void generateCsvFile(String sFileName,Connection conn) throws IOException,Exception
	{	
		System.out.println("calling generateCsvFile..................");
		ResultSet rs = null;
		PreparedStatement pstmt = null;
		String sql="";	
		try
		{
			File newFile = new File(sFileName);
			if(newFile.exists())
				newFile.createNewFile();
			BufferedWriter writer = new BufferedWriter(new FileWriter(sFileName));
			writer.append("sku");
			writer.append(',');
			writer.append("qty");
			writer.append('\n');
			
			/*sql = " SELECT SKU, SUM(FINSTK) FINSTK FROM ( SELECT SKU, SUM(FINSTK) FINSTK FROM ( SELECT S.ITEM_CODE SKU, SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) FINSTK"
				+ "	FROM STOCK S WHERE S.INV_STAT IN ('CASPK','ACTPK') GROUP BY S.ITEM_CODE HAVING SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) > 0"
				+ " UNION ALL SELECT SI.ITEM_CODE, -1 * SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) FROM SORDITEM SI , SORDER S, SORDDET SD"
				+ " WHERE SI.SALE_ORDER = S.SALE_ORDER AND SI.SALE_ORDER = SD.SALE_ORDER AND SI.LINE_NO = SD.LINE_NO AND SI.LINE_TYPE = 'I'"
				+ " AND S.STATUS NOT IN ('C','X') AND SI.STATUS NOT IN ('C','X') AND SD.STATUS NOT IN ('C','X')"
				+ " GROUP BY SI.ITEM_CODE HAVING SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) <> 0 ) GROUP BY SKU HAVING SUM(FINSTK) > 0"
				+ " UNION ALL SELECT ITEM_CODE, 0  FROM ITEM WHERE ITEM_PARNT IS NOT NULL) GROUP BY SKU";*/
			
			sql = " SELECT SKU, SUM(FINSTK) FINSTK FROM ("
				+ " SELECT SKU, SUM(CEIL(FINSTK * FN_GET_STKSYNCPRC(TRIM(ITEM_SER),'W_STKSYNMGNT'))) FINSTK"
				+ " FROM ( SELECT S.ITEM_CODE SKU, SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) FINSTK,I.ITEM_SER FROM STOCK S, ITEM I"
				+ " WHERE S.ITEM_CODE = I.ITEM_CODE AND I.TRADE_MARK = 'RVB2B' AND S.INV_STAT IN ('CASPK','ACTPK')"
				+ " GROUP BY S.ITEM_CODE,I.ITEM_SER HAVING SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) > 0"
				+ " UNION ALL"
				+ " SELECT SI.ITEM_CODE, -1 * SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP),I.ITEM_SER"
				+ " FROM SORDITEM SI , SORDER S, SORDDET SD, ITEM I WHERE SI.SALE_ORDER = S.SALE_ORDER AND SI.SALE_ORDER = SD.SALE_ORDER"
				+ " AND SI.LINE_NO = SD.LINE_NO AND SI.LINE_TYPE = 'I' AND SD.ITEM_CODE = I.ITEM_CODE AND I.TRADE_MARK = 'RVB2B' AND S.STATUS NOT IN ('C','X')"
				+ " AND SI.STATUS NOT IN ('C','X') AND SD.STATUS NOT IN ('C','X') GROUP BY SI.ITEM_CODE,I.ITEM_SER HAVING SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) <> 0 ) GROUP BY SKU HAVING SUM(FINSTK) > 0"
				+ " UNION ALL"
				+ " SELECT SKU, SUM(FINSTK) FINSTK FROM ( SELECT S.ITEM_CODE SKU, SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) FINSTK,I.ITEM_SER"
				+ " FROM STOCK S, ITEM I WHERE S.ITEM_CODE = I.ITEM_CODE AND NVL(I.TRADE_MARK,'X')<> 'RVB2B' AND S.INV_STAT IN ('CASPK','ACTPK')"
				+ " GROUP BY S.ITEM_CODE,I.ITEM_SER HAVING SUM(S.QUANTITY - S.ALLOC_QTY - CASE WHEN S.HOLD_QTY IS NULL THEN 0 ELSE S.HOLD_QTY END) > 0"
				+ " UNION ALL"
				+ " SELECT SI.ITEM_CODE, -1 * SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP),I.ITEM_SER"
				+ " FROM SORDITEM SI , SORDER S, SORDDET SD, ITEM I WHERE SI.SALE_ORDER = S.SALE_ORDER AND SI.SALE_ORDER = SD.SALE_ORDER"
				+ " AND SI.LINE_NO = SD.LINE_NO AND SI.LINE_TYPE = 'I' AND SD.ITEM_CODE = I.ITEM_CODE AND NVL(I.TRADE_MARK,'X')<> 'RVB2B' AND S.STATUS NOT IN ('C','X') AND SI.STATUS NOT IN ('C','X') AND SD.STATUS NOT IN ('C','X')"
				+ " GROUP BY SI.ITEM_CODE,I.ITEM_SER HAVING SUM(SI.QUANTITY - SI.QTY_ALLOC - SI.QTY_DESP) <> 0 ) GROUP BY SKU HAVING SUM(FINSTK) > 0"
				+ " UNION ALL"
				+ " SELECT ITEM_CODE, 0 FROM ITEM WHERE NVL(TRADE_MARK,'X')<>'RVB2B' AND ITEM_PARNT IS NOT NULL) GROUP BY SKU";
			pstmt = conn.prepareStatement(sql);
					
			rs = pstmt.executeQuery();
			
			while(rs.next())
			{
				writer.append("\""+checkNullAndTrim(rs.getString(1))+"\"");
				writer.append(',');
				writer.append("\""+checkNullAndTrim(rs.getString(2))+"\"");
				writer.append('\n');
			}		
			if(rs != null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt !=null)
			{
				pstmt.close();
				pstmt = null;
			}
	
			writer.flush();
			writer.close();		
		}
		
		catch(Exception e)
		{
			System.out.println("Exception in generateCsvFile ::::::::::: " + e);
			e.printStackTrace();
			throw new Exception(e);
		}
		finally
		{
			if(rs!=null)
			{
				rs.close();
				rs = null;
			}
			if(pstmt!=null)
			{
				pstmt.close();
				pstmt = null;
			}
		}

	}
	private  void putFileFTP(String username, String host, String password, String remotefile, String localfile,int port)
	{
		 FTPClient ftpClient = new FTPClient();
		 System.out.println("preparing the host information for ftp.");
	        try 
	        {
	        	System.out.println("Remote File: "+remotefile);
	        	System.out.println("Local File: "+localfile);
	            ftpClient.connect(host, port);
	            showServerReply(ftpClient);
	            int replyCode = ftpClient.getReplyCode();
	            boolean uploadStatus= false;
	            if (!FTPReply.isPositiveCompletion(replyCode)) 
	            {
	                System.out.println("Operation failed. Server reply code: " + replyCode);
	                return;
	            }
	            boolean success = ftpClient.login(username, password);
	            showServerReply(ftpClient);
	            ftpClient.setFileType(FTP.BINARY_FILE_TYPE);
	            ftpClient.enterLocalPassiveMode();
	            if (!success) 
	            {
	                System.out.println("Could not login to the server");
	                return;
	            } 
	            else 
	            {
	                System.out.println("LOGGED IN SERVER");
	   
	                File firstLocalFile = new File(localfile);
	                InputStream inputStream = new FileInputStream(firstLocalFile);
	                uploadStatus = ftpClient.storeFile(remotefile, inputStream);
	                inputStream.close();
	                
	                if (ftpClient.isConnected()) 
	                {
	                    ftpClient.logout();
	                    ftpClient.disconnect();
	                }
	                System.out.println("File Uploaded Status:"+uploadStatus);
	                if(uploadStatus)
	                {
	                	System.out.println("File Uploaded successfully");
	                }
	                else
	                {
	                	System.out.println("File can't Uploaded successfully");
	                }
	            }
	        } 
	        catch (IOException ex) 
	        {
	            System.out.println("Oops! Something wrong happened");
	            ex.printStackTrace();
	        }	
	}
	private static void showServerReply(FTPClient ftpClient) 
	{
		String[] replies = ftpClient.getReplyStrings();
		if (replies != null && replies.length > 0) 
		{
			for (String aReply : replies) 
			{
				System.out.println("SERVER: " + aReply);
			}
		}
	}
	
	public String checkNullAndTrim(String input)
	{
		if (input == null || "null".equalsIgnoreCase(input))
		{
			input= "";
		}
		return input.trim();
	}
	private  void putFileSFTP(String username, String host, String password, String remoteDestPath, String localFile,int port)
	{
		Session session = null;
		Channel channel = null;
		ChannelSftp channelSftp = null;
		System.out.println("preparing the host information for sftp.");
		try 
		{
			System.out.println("user name: ["+username+"]password["+password+"]host["+host+"]Port["+port+"]");
			System.out.println("Localfile:"+localFile);
			System.out.println("RemotePath:"+remoteDestPath);
			JSch jsch = new JSch();
			session = jsch.getSession(username, host, port);
			session.setPassword(password);
			java.util.Properties config = new java.util.Properties();
			config.put("StrictHostKeyChecking", "no");
			session.setConfig(config);
			session.connect();
			System.out.println("Host connected.");
			channel = session.openChannel("sftp");
			channel.connect();
			System.out.println("sftp channel opened and connected.");
			channelSftp = (ChannelSftp) channel;
			channelSftp.cd(remoteDestPath);
			File f = new File(localFile);
			channelSftp.put(new FileInputStream(f), f.getName());
			System.out.println("File Uploaded successfully");
		} catch (Exception ex) 
		{
			System.out.println("Exception found while Uploading a file.");
			ex.printStackTrace();
		}
		finally
		{
			channelSftp.exit();
			System.out.println("sftp Channel exited.");
			channel.disconnect();
			System.out.println("Channel disconnected.");
			session.disconnect();
			System.out.println("Host Session disconnected.");
		}
	}
}
